#pragma once
////////////////////////////////////////////////////////////////////////////
#ifndef	CONFIG_H
#define	CONFIG_H
////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////
#include <afxmt.h>
#include <afxtempl.h>
#include "FileUtil.h"
#include "Broadcaster.h"
#include "ConfigDlg.h"
#include "DllManager.h"
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
// Structs use to store differents values and description of cmd parameters
struct StructIntParam
{
	int		value;
	CString desc;
	StructIntParam(int iValue, CString iDesc)
		{
		value=iValue;
		desc=iDesc;
		}
};
/////////////////////////////////////////////////////////////////////////////
struct StructStringParam
{
	CString value;
	CString desc;
	StructStringParam(CString iValue, CString iDesc)
		{
		value=iValue;
		desc=iDesc;
		}
};
/////////////////////////////////////////////////////////////////////////////
#define CONFIG_CFG			1
#define CONFIG_DATA			2
#define CONFIG_GPRS			3
#define CONFIG_NWK			4
#define CONFIG_PHB			5
#define CONFIG_POW			6
#define CONFIG_SMS			7
#define CONFIGE_SND			8
#define CONFIG_SPC			9
#define CONFIG_STY			10
#define CONFIG_SIM			11
////////////////////////////////////////////////////////////////////////////
// ISDN / telephony numbering plan
#define kNumberingPlanUnknown			129			// national / international unknown
#define kNumberingPlanInternational		145			// international number
#define kNumberingPlanNational			161			// national number
/////////////////////////////////////////////////////////////////////////////
class CConfigDlg;
class CDllManager;
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CConfig : public CObject, public CBroadcaster
{
private :
	// the name of section in db text file, use in load/save function
	char*				mSectionName;		
protected:
	CDllManager*		mDllManager;
	CCriticalSection	mCS;
	UInt16				mCfgID;
	CList<CConfigDlg*,CConfigDlg*&> mDlgList;	

public:
	CConfig() {};
	CConfig(UInt16 iCfgID, CDllManager* iDllManager, char* iSectionName=NULL);
	virtual ~CConfig();
	// Load And Save Shortcuts functions
	virtual CString		LoadStringInSection(char* iKeyP, char* iDefaultValueP);
	virtual int			LoadIntInSection(char* iKeyP, UInt32 iDefaultValueP);
	virtual Bool		SaveIntInSection(char* iKeyP, UInt32 iValue);
	virtual Bool		SaveStringInSection(char* iKeyP, CString iValue);
	virtual void		DeleteSection();

	virtual void		SetDllManager(CDllManager* iDllManager);
	virtual Bool		Load()=0;
	virtual Bool		Save()=0;
	virtual CDialog*	GetUI();

	// Add a Dialog to this Config
    virtual void		AddDialog(CConfigDlg* iDlg);
	// Return the number of dialogs owned
	virtual INT_PTR		GetDialogCount();
	// Get the iIndex Dialog
	virtual CConfigDlg* GetDialog(int iIndex);

	virtual void 		StartCfgAccess();
	virtual void 		EndCfgAccess();
	virtual void 		Broadcast();
	virtual void 		Broadcast(int iConfigEvent);
	// tell the dllmanger to update all dlg
	virtual void		UpdateUI();
	
	// Formatting API
	virtual void		FormatATMsg(CString iMsg, CCmd* iCmd, Bool iSilentMode);
	virtual void		FormatATStdError(UINT iErrorID, CCmd* iCmd, Bool iSilentMode);
	virtual void		FormatATError(CCmd* iCmd, Bool iSilentMode);
	virtual void		FormatATOK(CCmd* iCmd, Bool iSilentMode);

	virtual void		FormatATMsg(CString iMsg);
	virtual void		FormatATOK();
	
	virtual void		AppendVPMsg(CString iMsg, int iIconID=-1);		
};
#endif
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
